package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import com.ejie.p06b.datatype.model.P06B29T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu� la descripci�n del tipo.
 * Fecha de creaci�n: (25/02/2008)
 */
public class P06B29T00DAO {

	static private P06B29T00DAO instance = null;

	public static P06B29T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B29T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B29T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Inserta un registro de la BD
    * @param obj.
    *            objeto a insertar
    * @return void
    * @throws SQLException
    */
	public void insert(P06B29T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00DAO-insert");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = INSERT_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

        lstm.setString(1,obj.getNumExp().toUpperCase());
	    lstm.setString(2,obj.getIdentificador().toUpperCase());
	    lstm.setString(3,obj.getTipo().toUpperCase());
	    lstm.setString(4,obj.getRazsoc().toUpperCase());
	    lstm.setString(5,obj.getNombre().toUpperCase());
	    lstm.setString(6,obj.getApe1().toUpperCase());
	    lstm.setString(7,obj.getApe2().toUpperCase());
	    lstm.setString(8,obj.getDomici().toUpperCase());
	    lstm.setString(9,obj.getCodmun().toUpperCase());
	    lstm.setString(10,obj.getLocali().toUpperCase());
	    lstm.setString(11,obj.getCodpro().toUpperCase());
	    lstm.setString(12,obj.getCodpst().toUpperCase());
	    lstm.setString(13,obj.getTelefot().toUpperCase());
	    lstm.setString(14,obj.getTelefom().toUpperCase());
	    lstm.setString(15,obj.getTelefoc().toUpperCase());
	    lstm.setString(16,obj.getFax1().toUpperCase());
	    lstm.setString(17,obj.getFax2().toUpperCase());
	    lstm.setString(18,obj.getMail().toUpperCase());
	    lstm.setString(19,obj.getWeb().toUpperCase());

    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B29T00DAO-insert");
	}

	/**
    * Obtiene la lista de defensores cliente asociada al expediente
    * @param expediente.
    * @return Lista de objetos defensores cliente
	 * @throws Exception
    */
	public ArrayList<P06B29T00Datatype> selectAllByExp(String expediente, String tipo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00Datatype-selectAllByExp");
		ArrayList<P06B29T00Datatype> lista = new ArrayList<P06B29T00Datatype>();
		P06B29T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EXPTIPO;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj = new P06B29T00Datatype();
	        	obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B29_NUMEXP));
			    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B29_IDENTIFICADOR));
			    obj.setTipo(lrst.getString(P06BTablas.P06B_P06B29_TIPO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TIPO));
			    obj.setRazsoc(lrst.getString(P06BTablas.P06B_P06B29_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_RAZSOC));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B29_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B29_NOMBRE));
			    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B29_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE1));
			    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B29_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE2));
			    obj.setDomici(lrst.getString(P06BTablas.P06B_P06B29_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_DOMICI));
			    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B29_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODMUN));
			    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B29_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_LOCALI));
			    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B29_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPRO));
			    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B29_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPST));
			    obj.setTelefot(lrst.getString(P06BTablas.P06B_P06B29_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOT));
			    obj.setTelefom(lrst.getString(P06BTablas.P06B_P06B29_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOM));
			    obj.setTelefoc(lrst.getString(P06BTablas.P06B_P06B29_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOC));
			    obj.setFax1(lrst.getString(P06BTablas.P06B_P06B29_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX1));
			    obj.setFax2(lrst.getString(P06BTablas.P06B_P06B29_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX2));
			    obj.setMail(lrst.getString(P06BTablas.P06B_P06B29_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B29_MAIL));
			    obj.setWeb(lrst.getString(P06BTablas.P06B_P06B29_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B29_WEB));

	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B29T00Datatype-selectAllByExp");
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}

	/**
    * Obtiene la lista de departamentos de atencion al cliente asociada al expediente
    * @param expediente.
    * @return Lista de objetos de departamentos de atenci�n al cliente
	 * @throws Exception
    */
	public ArrayList<P06B29T00Datatype> selectInformeComunicarDGSFP2() throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00Datatype-selectInformeComunicarDGSFP2");
		ArrayList<P06B29T00Datatype> lista = new ArrayList<P06B29T00Datatype>();
		P06B29T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_LISTADO2;

        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
    	lstm = lconConexion.prepareStatement(sql);
    	lrst = lstm.executeQuery();
        while (lrst.next()) {
        	obj = new P06B29T00Datatype();
        	obj.setNumExp(lrst.getString(1));
        	obj.setTipo(lrst.getString(2));
		    obj.setRazsoc(lrst.getString(3)==null?"":lrst.getString(3));
		    obj.setNombre(lrst.getString(4)==null?"":lrst.getString(4));
		    obj.setApe1(lrst.getString(5)==null?"":lrst.getString(5));
		    obj.setApe2(lrst.getString(6)==null?"":lrst.getString(6));
		    obj.setDomici(lrst.getString(7)==null?"":lrst.getString(7));

        	lista.add(obj);
        }
        P06BLog.send(2,this, "Fin P06B29T00Datatype-selectInformeComunicarDGSFP2");
		lrst.close();
		lstm.close();
		lconConexion.close();
		return lista;
	}

	/**
    */
	public P06B29T00Datatype selectDefClienteAdherido(String adheridoAlColegioExpedienteFicticio, String adheridoAlColegio) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00Datatype-selectDefClienteAdherido");
		P06B29T00Datatype p06B29T00Datatype = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EXPTIPO;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,adheridoAlColegioExpedienteFicticio);
        	lstm.setString(2,adheridoAlColegio);
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	p06B29T00Datatype = new P06B29T00Datatype();
	        	p06B29T00Datatype.setNumExp(lrst.getString(P06BTablas.P06B_P06B29_NUMEXP));
            	if (lrst.getString(P06BTablas.P06B_P06B29_IDENTIFICADOR).equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIODNIFICTICIO) ||
            		lrst.getString(P06BTablas.P06B_P06B29_IDENTIFICADOR).equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCIFFICTICIO)){
        			p06B29T00Datatype.setIdentificador("");
            	}else{
            		p06B29T00Datatype.setIdentificador(lrst.getString(P06BTablas.P06B_P06B29_IDENTIFICADOR));
            	}
			    p06B29T00Datatype.setTipo(lrst.getString(P06BTablas.P06B_P06B29_TIPO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TIPO));
			    p06B29T00Datatype.setRazsoc(lrst.getString(P06BTablas.P06B_P06B29_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_RAZSOC));
			    p06B29T00Datatype.setNombre(lrst.getString(P06BTablas.P06B_P06B29_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B29_NOMBRE));
			    p06B29T00Datatype.setApe1(lrst.getString(P06BTablas.P06B_P06B29_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE1));
			    p06B29T00Datatype.setApe2(lrst.getString(P06BTablas.P06B_P06B29_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE2));
			    p06B29T00Datatype.setDomici(lrst.getString(P06BTablas.P06B_P06B29_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_DOMICI));
			    p06B29T00Datatype.setCodmun(lrst.getString(P06BTablas.P06B_P06B29_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODMUN));
			    p06B29T00Datatype.setLocali(lrst.getString(P06BTablas.P06B_P06B29_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_LOCALI));
			    p06B29T00Datatype.setCodpro(lrst.getString(P06BTablas.P06B_P06B29_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPRO));
			    p06B29T00Datatype.setCodpst(lrst.getString(P06BTablas.P06B_P06B29_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPST));
			    p06B29T00Datatype.setTelefot(lrst.getString(P06BTablas.P06B_P06B29_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOT));
			    p06B29T00Datatype.setTelefom(lrst.getString(P06BTablas.P06B_P06B29_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOM));
			    p06B29T00Datatype.setTelefoc(lrst.getString(P06BTablas.P06B_P06B29_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOC));
			    p06B29T00Datatype.setFax1(lrst.getString(P06BTablas.P06B_P06B29_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX1));
			    p06B29T00Datatype.setFax2(lrst.getString(P06BTablas.P06B_P06B29_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX2));
			    p06B29T00Datatype.setMail(lrst.getString(P06BTablas.P06B_P06B29_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B29_MAIL));
			    p06B29T00Datatype.setWeb(lrst.getString(P06BTablas.P06B_P06B29_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B29_WEB));
	        }
	        P06BLog.send(2,this, "Fin P06B29T00Datatype-selectDefClienteAdherido");
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return p06B29T00Datatype;
	}


	/**
    */
	public void updateDefClienteAdherido(P06B29T00Datatype defCliente) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00Datatype-updateDefClienteAdherido");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = UPDATE_ADHERIDO;
        try{
	        lstm = lconConexion.prepareStatement(sql);

	        lstm.setString(2,defCliente.getTipo().toUpperCase());
	        lstm.setString(7,defCliente.getNumExp().toUpperCase());
			if ("".equals(defCliente.getIdentificador())){
			    if (defCliente.getTipo().toUpperCase().equals(P06BConstantes.P06B_PERSONA_FISICA)){
			    	defCliente.setIdentificador(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIODNIFICTICIO.toUpperCase());
			    	lstm.setString(1,P06BConstantes.P06B_AC_ADHERIDOALCOLEGIODNIFICTICIO.toUpperCase());
			    }else{
			    	defCliente.setIdentificador(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIODNIFICTICIO.toUpperCase());
			    	lstm.setString(1,P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCIFFICTICIO.toUpperCase());
			    }
		    	lstm.setNull(3, java.sql.Types.VARCHAR);
		    	lstm.setNull(4, java.sql.Types.VARCHAR);
		    	lstm.setNull(5, java.sql.Types.VARCHAR);
		    	lstm.setNull(6, java.sql.Types.VARCHAR);
		    	defCliente.setRazsoc(null);
		    	defCliente.setNombre(null);
		    	defCliente.setApe1(null);
		    	defCliente.setApe2(null);
			}else{
			    lstm.setString(1,defCliente.getIdentificador().toUpperCase());
		    	defCliente.setIdentificador(defCliente.getIdentificador().toUpperCase());
			    if (defCliente.getTipo().toUpperCase().equals(P06BConstantes.P06B_PERSONA_FISICA)){
			    	lstm.setNull(3, java.sql.Types.VARCHAR);
			    	lstm.setString(4,defCliente.getNombre().toUpperCase());
			    	lstm.setString(5,defCliente.getApe1().toUpperCase());
			    	lstm.setString(6,defCliente.getApe2().toUpperCase());
			    	defCliente.setRazsoc(null);
			    	defCliente.setNombre(defCliente.getNombre().toUpperCase());
			    	defCliente.setApe1(defCliente.getApe1().toUpperCase());
			    	defCliente.setApe2(defCliente.getApe2().toUpperCase());
			    }else{
			    	lstm.setString(3,defCliente.getRazsoc().toUpperCase());
			    	lstm.setNull(4, java.sql.Types.VARCHAR);
			    	lstm.setNull(5, java.sql.Types.VARCHAR);
			    	lstm.setNull(6, java.sql.Types.VARCHAR);
			    	defCliente.setRazsoc(defCliente.getRazsoc().toUpperCase());
			    	defCliente.setNombre(null);
			    	defCliente.setApe1(null);
			    	defCliente.setApe2(null);
			    }
			}
		    if (defCliente.getNumExp().toUpperCase().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCVEXPEDIENTEFICTICIO)){
			    lstm.setString(8,P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV);
		    }else{
			    lstm.setString(8,P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG);
		    }
	    	lstm.executeUpdate();
	        P06BLog.send(2,this, "Fin P06B29T00Datatype-updateDefClienteAdherido");
        }catch (SQLException sqle){
	        P06BLog.send(2,this, "updateDefClienteAdherido: " + sqle.getMessage());
	        throw(sqle);
	    }finally {
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
	}


	/**
    * Obtiene la lista de defensores cliente asociada al expediente
    * @param expediente.
    * @return Lista de objetos defensores cliente
	 * @throws Exception
    */
	public ArrayList<P06B29T00Datatype> selectAllByExpIncorporacionModTramitagune(String expediente, int nCorrelAtencionPeticionEnRevision, String tipo, String expedienteEnAtencionDefensaCliente) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00Datatype-selectAllByExpIncorporacionDEC");
		ArrayList<P06B29T00Datatype> lista = new ArrayList<P06B29T00Datatype>();
		P06B29T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(3,expedienteEnAtencionDefensaCliente.toUpperCase());
        	lstm.setString(4,tipo);
        	lstm.setString(5,expediente.toUpperCase());
        	lstm.setInt(6,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(7,expedienteEnAtencionDefensaCliente.toUpperCase());
        	lstm.setString(8,tipo);
        	lstm.setString(9,expediente.toUpperCase());
        	lstm.setInt(10,nCorrelAtencionPeticionEnRevision);
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");

	        	obj = new P06B29T00Datatype();
	        	obj.setNumExp(expediente.toUpperCase());
	        	obj.setOperacion(operacion);
//			    obj.setAprobado(0);
	        	if (operacion==0){
				    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B29_IDENTIFICADOR));
				    obj.setTipo(lrst.getString(P06BTablas.P06B_P06B29_TIPO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TIPO));
				    obj.setRazsoc(lrst.getString(P06BTablas.P06B_P06B29_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_RAZSOC));
				    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B29_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B29_NOMBRE));
				    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B29_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE1));
				    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B29_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE2));
				    obj.setDomici(lrst.getString(P06BTablas.P06B_P06B29_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_DOMICI));
				    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B29_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODMUN));
				    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B29_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_LOCALI));
				    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B29_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPRO));
				    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B29_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPST));
				    obj.setTelefot(lrst.getString(P06BTablas.P06B_P06B29_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOT));
				    obj.setTelefom(lrst.getString(P06BTablas.P06B_P06B29_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOM));
				    obj.setTelefoc(lrst.getString(P06BTablas.P06B_P06B29_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOC));
				    obj.setFax1(lrst.getString(P06BTablas.P06B_P06B29_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX1));
				    obj.setFax2(lrst.getString(P06BTablas.P06B_P06B29_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX2));
				    obj.setMail(lrst.getString(P06BTablas.P06B_P06B29_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B29_MAIL));
				    obj.setWeb(lrst.getString(P06BTablas.P06B_P06B29_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B29_WEB));
	        	}

	        	if (operacion==1 || operacion==2){
				    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B79_DC_IDENTIFICADOR));
				    obj.setTipo(lrst.getString(P06BTablas.P06B_P06B79_DC_TIPO)==null?"":lrst.getString(P06BTablas.P06B_P06B79_DC_TIPO));
				    obj.setRazsoc(lrst.getString(P06BTablas.P06B_P06B79_DC_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B79_DC_RAZSOC));
				    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B79_DC_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B79_DC_NOMBRE));
				    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B79_DC_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B79_DC_APE1));
				    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B79_DC_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B79_DC_APE2));
				    if (operacion==2){
				    	//Inicializar campos no aportados por Tramitagune para que no se pierdan
				    	obj.setDomici(lrst.getString(P06BTablas.P06B_P06B29_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_DOMICI));
					    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B29_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODMUN));
					    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B29_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_LOCALI));
					    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B29_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPRO));
					    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B29_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPST));
					    obj.setTelefot(lrst.getString(P06BTablas.P06B_P06B29_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOT));
					    obj.setTelefom(lrst.getString(P06BTablas.P06B_P06B29_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOM));
					    obj.setTelefoc(lrst.getString(P06BTablas.P06B_P06B29_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOC));
					    obj.setFax1(lrst.getString(P06BTablas.P06B_P06B29_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX1));
					    obj.setFax2(lrst.getString(P06BTablas.P06B_P06B29_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX2));
					    obj.setMail(lrst.getString(P06BTablas.P06B_P06B29_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B29_MAIL));
					    obj.setWeb(lrst.getString(P06BTablas.P06B_P06B29_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B29_WEB));
				    }
				}

			    if (operacion==0 || operacion==2){
			    	P06B29T00Datatype datos29Originales = new P06B29T00Datatype();
			    	datos29Originales.setNumExp(expediente.toUpperCase());
				    datos29Originales.setIdentificador(lrst.getString(P06BTablas.P06B_P06B29_IDENTIFICADOR));
				    datos29Originales.setTipo(lrst.getString(P06BTablas.P06B_P06B29_TIPO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TIPO));
				    datos29Originales.setRazsoc(lrst.getString(P06BTablas.P06B_P06B29_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_RAZSOC));
				    datos29Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B29_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B29_NOMBRE));
				    datos29Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B29_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE1));
				    datos29Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B29_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_APE2));
				    datos29Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B29_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_DOMICI));
				    datos29Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B29_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODMUN));
				    datos29Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B29_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B29_LOCALI));
				    datos29Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B29_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPRO));
				    datos29Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B29_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B29_CODPST));
				    datos29Originales.setTelefot(lrst.getString(P06BTablas.P06B_P06B29_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOT));
				    datos29Originales.setTelefom(lrst.getString(P06BTablas.P06B_P06B29_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOM));
				    datos29Originales.setTelefoc(lrst.getString(P06BTablas.P06B_P06B29_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B29_TELEFOC));
				    datos29Originales.setFax1(lrst.getString(P06BTablas.P06B_P06B29_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX1));
				    datos29Originales.setFax2(lrst.getString(P06BTablas.P06B_P06B29_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B29_FAX2));
				    datos29Originales.setMail(lrst.getString(P06BTablas.P06B_P06B29_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B29_MAIL));
				    datos29Originales.setWeb(lrst.getString(P06BTablas.P06B_P06B29_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B29_WEB));
			    	obj.setDatos29Originales(datos29Originales);
        		}

	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B29T00Datatype-selectAllByExpIncorporacionDEC");
	    }finally {
        	if(lrst!=null)
        		lrst.close();
        	if(lstm!=null)
	        	lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}


	/**
    * Elimina todos los defensores de cliente asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos defensores de cliente eliminamos
    * @throws SQLException
    */
	public void deleteAllByExp(String exp, String tipo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00DAO-deleteAllByExp");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEALL_BYEXPTIPO;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,tipo);
    	lstm.executeUpdate();
    	//Cierro recursos
    	if(lstm!=null) lstm.close();
    	if(lconConexion!=null)lconConexion.close();
        P06BLog.send(2,this, "Fin P06B29T00DAO-deleteAllByExp");
	}


	/**
    * Elimina todos los defensores de cliente asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos defensores de cliente eliminamos
    * @throws SQLException
    */
	public void deleteByExpId(String exp, String id, String tipo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B29T00DAO-deleteByExpId");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEBYEXPIDTIPO;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,id);
    	lstm.setString(3,tipo);
    	lstm.executeUpdate();
    	if(lstm!=null) lstm.close();
    	if(lconConexion!=null)lconConexion.close();
        P06BLog.send(2,this, "Fin P06B29T00DAO-deleteByExpId");
	}

	private static String INSERT_COMPLETA =
		"INSERT INTO "+ P06BTablas.P06B_P06B29T00_TABLA +
		" ("+
		P06BTablas.P06B_P06B29_NUMEXP + "," +
		P06BTablas.P06B_P06B29_IDENTIFICADOR + "," +
		P06BTablas.P06B_P06B29_TIPO + "," +
		P06BTablas.P06B_P06B29_RAZSOC + "," +
		P06BTablas.P06B_P06B29_NOMBRE + "," +
		P06BTablas.P06B_P06B29_APE1 + "," +
		P06BTablas.P06B_P06B29_APE2 + "," +
		P06BTablas.P06B_P06B29_DOMICI + "," +
		P06BTablas.P06B_P06B29_CODMUN + "," +
		P06BTablas.P06B_P06B29_LOCALI + "," +
		P06BTablas.P06B_P06B29_CODPRO + "," +
		P06BTablas.P06B_P06B29_CODPST + "," +
		P06BTablas.P06B_P06B29_TELEFOT + "," +
		P06BTablas.P06B_P06B29_TELEFOM + "," +
		P06BTablas.P06B_P06B29_TELEFOC + "," +
		P06BTablas.P06B_P06B29_FAX1 + "," +
		P06BTablas.P06B_P06B29_FAX2 + "," +
		P06BTablas.P06B_P06B29_MAIL + "," +
		P06BTablas.P06B_P06B29_WEB +
		")"+
		" VALUES(?,?,?,?,?,?,?,?,TO_NUMBER(?),TO_NUMBER(?),TO_NUMBER(?),?,?,?,?,?,?,?,?)";

	private static String UPDATE_ADHERIDO =
		"UPDATE "+ P06BTablas.P06B_P06B29T00_TABLA +
		" SET " +
		P06BTablas.P06B_P06B29_IDENTIFICADOR + "=?, " +
		P06BTablas.P06B_P06B29_TIPO + "=?, " +
		P06BTablas.P06B_P06B29_RAZSOC + "=?, " +
		P06BTablas.P06B_P06B29_NOMBRE + "=?, " +
		P06BTablas.P06B_P06B29_APE1 + "=?, " +
		P06BTablas.P06B_P06B29_APE2 + "=? " +
		"WHERE " + P06BTablas.P06B_P06B29_NUMEXP + "=? " +
		"AND " + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "= ?";

	private static String SELECTALL_BY_EXPTIPO =
		"SELECT " +
		P06BTablas.P06B_P06B29_NUMEXP + "," +
		P06BTablas.P06B_P06B29_IDENTIFICADOR + "," +
		P06BTablas.P06B_P06B29_TIPO + "," +
		P06BTablas.P06B_P06B29_RAZSOC + "," +
		P06BTablas.P06B_P06B29_NOMBRE + "," +
		P06BTablas.P06B_P06B29_APE1 + "," +
		P06BTablas.P06B_P06B29_APE2 + "," +
		P06BTablas.P06B_P06B29_DOMICI + "," +
		P06BTablas.P06B_P06B29_CODMUN + "," +
		P06BTablas.P06B_P06B29_LOCALI + "," +
		P06BTablas.P06B_P06B29_CODPRO + "," +
		P06BTablas.P06B_P06B29_CODPST + "," +
		P06BTablas.P06B_P06B29_TELEFOT + "," +
		P06BTablas.P06B_P06B29_TELEFOM + "," +
		P06BTablas.P06B_P06B29_TELEFOC + "," +
		P06BTablas.P06B_P06B29_FAX1 + "," +
		P06BTablas.P06B_P06B29_FAX2 + "," +
		P06BTablas.P06B_P06B29_MAIL + "," +
		P06BTablas.P06B_P06B29_WEB +
		" FROM " + P06BTablas.P06B_P06B29T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B29_NUMEXP + "= ?"
		+ " AND " + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B29_IDENTIFICADOR;

	private static String SELECT_LISTADO2 =
		"SELECT " +
		P06BTablas.P06B_P06B20_NUMEXP + "," +
		P06BTablas.P06B_P06B29_TIPO + "," +
		P06BTablas.P06B_P06B29_RAZSOC + "," +
		P06BTablas.P06B_P06B29_NOMBRE + "," +
		P06BTablas.P06B_P06B29_APE1 + "," +
		P06BTablas.P06B_P06B29_APE2 + "," +
		P06BTablas.P06B_P06B29_DOMICI + "||LPAD(" + P06BTablas.P06B_P06B29_CODPST + ",6)|| LPAD(UPPER(DS_O),LENGTH(UPPER(DS_O))+1)" +
		" FROM P06BENS00, " + P06BTablas.P06B_P06B29T00_TABLA + ", " + P06BTablas.P06B_P06B20T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B29_NUMEXP + " = " +
		"DECODE(" + P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE + "," + P06BConstantes.P06B_AC_CUENTACONSERVICIO + "," + P06BTablas.P06B_P06B20_NUMEXP + "," +
		"DECODE(" + P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE + "," + P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV + ",'" + P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCVEXPEDIENTEFICTICIO + "','" + P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCGEXPEDIENTEFICTICIO + "')) AND " +
		P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE + " in (" + P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV + "," + P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG + "," + P06BConstantes.P06B_AC_CUENTACONSERVICIO + ") AND " +
		P06BTablas.P06B_P06B20_ESTADO + " in ('" + P06BConstantes.P06B_CORREDORES_ESTADO_ALTA + "','" + P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION + "','" + P06BConstantes.P06B_CORREDORES_ESTADO_REVISION + "','" + P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA + "','" + P06BConstantes.P06B_CORREDORES_ESTADO_BAJA + "') " +
		" AND TO_NUMBER(PROVINCIA_ID(+))= " + P06BTablas.P06B_P06B29_CODPRO +
		" AND TO_NUMBER(MUNICIPIO_ID(+)) = " + P06BTablas.P06B_P06B29_CODMUN +
		" AND TO_NUMBER(NUMERO(+)) = " + P06BTablas.P06B_P06B29_LOCALI +
		" ORDER BY " + P06BTablas.P06B_P06B20_NUMEXP + ", " + P06BTablas.P06B_P06B29_IDENTIFICADOR;

	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP =
		"SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B29_IDENTIFICADOR + ","
		+ "A." + P06BTablas.P06B_P06B29_TIPO + ","
		+ "A." + P06BTablas.P06B_P06B29_RAZSOC + ","
		+ "A." + P06BTablas.P06B_P06B29_NOMBRE + ","
		+ "A." + P06BTablas.P06B_P06B29_APE1 + ","
		+ "A." + P06BTablas.P06B_P06B29_APE2 + ","
		+ "A." + P06BTablas.P06B_P06B29_DOMICI + ","
		+ "A." + P06BTablas.P06B_P06B29_CODMUN + ","
		+ "A." + P06BTablas.P06B_P06B29_LOCALI + ","
		+ "A." + P06BTablas.P06B_P06B29_CODPRO + ","
		+ "A." + P06BTablas.P06B_P06B29_CODPST + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOT + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOM + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOC + ","
		+ "A." + P06BTablas.P06B_P06B29_FAX1 + ","
		+ "A." + P06BTablas.P06B_P06B29_FAX2 + ","
		+ "A." + P06BTablas.P06B_P06B29_MAIL + ","
		+ "A." + P06BTablas.P06B_P06B29_WEB + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_TIPO + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_APE2
		+ " FROM " + P06BTablas.P06B_P06B29T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B79T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC + "=?"
		+ " AND A." + P06BTablas.P06B_P06B29_NUMEXP + "= ?"
		+ " AND A." + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "= ?"
		+ " AND A." + P06BTablas.P06B_P06B29_NUMEXP + "=S." + P06BTablas.P06B_P06B79_DC_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B29_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_TIPO + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_APE2
		+ " FROM " + P06BTablas.P06B_P06B79T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B79T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B29_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B29T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B29_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND A." + P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC + "=?"
		+ " AND C." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR
		+ " ORDER BY 1 DESC,2";

	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXPOLD =
		"SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B29_IDENTIFICADOR + ","
		+ "A." + P06BTablas.P06B_P06B29_TIPO + ","
		+ "A." + P06BTablas.P06B_P06B29_RAZSOC + ","
		+ "A." + P06BTablas.P06B_P06B29_NOMBRE + ","
		+ "A." + P06BTablas.P06B_P06B29_APE1 + ","
		+ "A." + P06BTablas.P06B_P06B29_APE2 + ","
		+ "A." + P06BTablas.P06B_P06B29_DOMICI + ","
		+ "A." + P06BTablas.P06B_P06B29_CODMUN + ","
		+ "A." + P06BTablas.P06B_P06B29_LOCALI + ","
		+ "A." + P06BTablas.P06B_P06B29_CODPRO + ","
		+ "A." + P06BTablas.P06B_P06B29_CODPST + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOT + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOM + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOC + ","
		+ "A." + P06BTablas.P06B_P06B29_FAX1 + ","
		+ "A." + P06BTablas.P06B_P06B29_FAX2 + ","
		+ "A." + P06BTablas.P06B_P06B29_MAIL + ","
		+ "A." + P06BTablas.P06B_P06B29_WEB + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_TIPO + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B79_DC_APE2
		+ " FROM " + P06BTablas.P06B_P06B29T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B79T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC + "=?"
		+ " AND A." + P06BTablas.P06B_P06B29_NUMEXP + "= ?"
		+ " AND A." + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "= ?"
		+ " AND A." + P06BTablas.P06B_P06B29_NUMEXP + "=S." + P06BTablas.P06B_P06B79_DC_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B29_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR
		+ " UNION"
		+ " SELECT 0, "
		+ "A." + P06BTablas.P06B_P06B29_IDENTIFICADOR + ","
		+ "A." + P06BTablas.P06B_P06B29_TIPO + ","
		+ "A." + P06BTablas.P06B_P06B29_RAZSOC + ","
		+ "A." + P06BTablas.P06B_P06B29_NOMBRE + ","
		+ "A." + P06BTablas.P06B_P06B29_APE1 + ","
		+ "A." + P06BTablas.P06B_P06B29_APE2 + ","
		+ "A." + P06BTablas.P06B_P06B29_DOMICI + ","
		+ "A." + P06BTablas.P06B_P06B29_CODMUN + ","
		+ "A." + P06BTablas.P06B_P06B29_LOCALI + ","
		+ "A." + P06BTablas.P06B_P06B29_CODPRO + ","
		+ "A." + P06BTablas.P06B_P06B29_CODPST + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOT + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOM + ","
		+ "A." + P06BTablas.P06B_P06B29_TELEFOC + ","
		+ "A." + P06BTablas.P06B_P06B29_FAX1 + ","
		+ "A." + P06BTablas.P06B_P06B29_FAX2 + ","
		+ "A." + P06BTablas.P06B_P06B29_MAIL + ","
		+ "A." + P06BTablas.P06B_P06B29_WEB + ", "
		+ "NULL, NULL, NULL, NULL, NULL, NULL"
		+ " FROM " + P06BTablas.P06B_P06B29T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B29_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B29T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B29_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "=?"
		+ " MINUS "
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B79T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC + "=?"
		+ " ) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B29_NUMEXP + "=?"
		+ " AND A." + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "=?"
		+ " AND C." + P06BTablas.P06B_P06B29_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B29_IDENTIFICADOR
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_TIPO + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B79_DC_APE2
		+ " FROM " + P06BTablas.P06B_P06B79T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B79T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B29_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B29T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B29_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B79_DC_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B79_DC_IDENTIFICADOR
		+ " ORDER BY 1 DESC,2";

	private static String DELETEALL_BYEXPTIPO =
		"DELETE FROM "+ P06BTablas.P06B_P06B29T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B29_NUMEXP + " = ?" +
		" AND " + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + " = ?";

	private static String DELETEBYEXPIDTIPO =
		"DELETE FROM "+ P06BTablas.P06B_P06B29T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B29_NUMEXP + " = ?"
		+ " AND " + P06BTablas.P06B_P06B29_IDENTIFICADOR + "= ?" +
		" AND " + P06BTablas.P06B_P06B29_TIPOATENCIONCLIENTE + " = ?";

}
